/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBData_Comum;
import fme.CBTabela;
import fme.CFType_Num0;
import fme.CFType_Valor0;
import fme.CHTabColModel;
import fme.CHTabQuadro;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.Frame_IdProm_3;
import fme.GroupableTableHeaderUI;
import fme.TabError;
import fme.TableKeyListener;
import fme._lib;
import fme.fmeFrame;

class CBTabela_Promocao
extends CBTabela {
    Frame_IdProm_3 P;
    int tab_index = 0;

    @Override
    public String getPagina() {
        return CBData.getPagina("IdProm_3", "IdProm_3_N", CBData.ListaOutrosBenef, this.tab_index);
    }

    CBTabela_Promocao() {
        this.P = (Frame_IdProm_3)fmeFrame.Paginas.getPage("IdProm_3");
        if (this.P == null) {
            return;
        }
        this.initialize();
    }

    CBTabela_Promocao(Frame_IdProm_3 p, int idx) {
        this.P = p;
        this.tab_index = idx;
        this.initialize();
    }

    void initialize() {
        this.tag = "Promocao";
        this.started = true;
        this.cols = new CHTabColModel[8];
        this.cols[0] = new CHTabColModel("mercado", "Mercado (id)", true, false, false, null);
        this.cols[1] = new CHTabColModel("mercado_d", "Mercado", false, false, true, null);
        this.cols[2] = new CHTabColModel("valor_p3", "Montante -3", true, true, true, new CFType_Valor0());
        this.cols[3] = new CHTabColModel("perc_p3", "% -3", true, false, true, new CFType_Num0());
        this.cols[4] = new CHTabColModel("valor_p2", "Montante -2", true, true, true, new CFType_Valor0());
        this.cols[5] = new CHTabColModel("perc_p2", "% -2", true, false, true, new CFType_Num0());
        this.cols[6] = new CHTabColModel("valor_p1", "Montante -1", true, true, true, new CFType_Valor0());
        this.cols[7] = new CHTabColModel("perc_p1", "% -1", true, false, true, new CFType_Num0());
        this.init_dados(4);
        this.init_handler(new CHTabQuadro(), this.P.getJTable_Promocao());
        this.P.getJTable_Promocao().addKeyListener(new TableKeyListener(this));
        this.handler.width = this.P.getJScrollPane_Promocao().getWidth() - 2;
        this.ui = new GroupableTableHeaderUI();
        this.ui.setH(2, this.P.getJTable_Promocao());
        this.ui.add_col(0, 0, 1, 2, "Mercado");
        this.ui.add_col(1, 0, 2, 1, "Ano -1");
        this.ui.add_col(1, 1, 1, 1, "Montante (\u20ac)");
        this.ui.add_col(2, 1, 1, 1, "(%)");
        this.ui.add_col(3, 0, 2, 1, "Ano -2");
        this.ui.add_col(3, 1, 1, 1, "Montante (\u20ac)");
        this.ui.add_col(4, 1, 1, 1, "(%)");
        this.ui.add_col(5, 0, 2, 1, "Ano -3");
        this.ui.add_col(5, 1, 1, 1, "Montante (\u20ac)");
        this.ui.add_col(6, 1, 1, 1, "(%)");
        this.P.getJTable_Promocao().getTableHeader().setUI(this.ui);
        this.cols[0].disable_row_calc = true;
        this.cols[1].disable_row_calc = true;
        this.cols[3].disable_row_calc = true;
        this.cols[5].disable_row_calc = true;
        this.cols[7].disable_row_calc = true;
        ((CHTabQuadro)this.handler).start_rows();
        ((CHTabQuadro)this.handler).row_editable[3] = false;
        this.keyCol = 0;
        ((String[])this.dados.elementAt((int)0))[0] = "PT";
        ((String[])this.dados.elementAt((int)1))[0] = "UE";
        ((String[])this.dados.elementAt((int)2))[0] = "P3";
        ((String[])this.dados.elementAt((int)3))[0] = "TT";
        ((String[])this.dados.elementAt((int)0))[1] = "Portugal";
        ((String[])this.dados.elementAt((int)1))[1] = "U.E.";
        ((String[])this.dados.elementAt((int)2))[1] = "Pa\u00edses Terceiros";
        ((String[])this.dados.elementAt((int)3))[1] = "Total";
        this.handler.set_col(1, 0.193, null);
        this.handler.set_col_text(2, 0.17, "R");
        this.handler.set_col_text(3, 0.1, "C");
        this.handler.set_col_text(4, 0.17, "R");
        this.handler.set_col_text(5, 0.1, "C");
        this.handler.set_col_text(6, 0.17, "R");
        this.handler.set_col_text(7, 0.1, "C");
        ((CHTabQuadro)this.handler).row_autocalc[3] = "$soma(+0,+1,+2)";
        CBData.Params.bind_ano_cand_update(this);
    }

    @Override
    public void on_external_update(String tag) {
        if (!this.started) {
            return;
        }
        this.ui = new GroupableTableHeaderUI();
        this.ui.setH(2, this.P.getJTable_Promocao());
        this.ui.add_col(0, 0, 1, 2, "Mercado");
        this.ui.add_col(1, 1, 1, 1, "Montante (\u20ac)");
        this.ui.add_col(2, 1, 1, 1, "(%)");
        this.ui.add_col(3, 1, 1, 1, "Montante (\u20ac)");
        this.ui.add_col(4, 1, 1, 1, "(%)");
        this.ui.add_col(5, 1, 1, 1, "Montante (\u20ac)");
        this.ui.add_col(6, 1, 1, 1, "(%)");
        if (!CBData.Params.getByName((String)"ano_cand").v.equals("")) {
            int ano = (int)CBData.Params.getByName("ano_cand").valueAsDouble();
            this.ui.add_col(1, 0, 2, 1, String.valueOf(ano - 3));
            this.cols[2].col_name = "Montante (\u20ac) - " + (ano - 3);
            this.cols[3].col_name = "Perc. (%) - " + (ano - 3);
            this.ui.add_col(3, 0, 2, 1, String.valueOf(ano - 2));
            this.cols[4].col_name = "Montante (\u20ac) - " + (ano - 2);
            this.cols[5].col_name = "Perc. (%) - " + (ano - 2);
            this.ui.add_col(5, 0, 2, 1, String.valueOf(ano - 1));
            this.cols[6].col_name = "Montante (\u20ac) - " + (ano - 1);
            this.cols[7].col_name = "Perc. (%) - " + (ano - 1);
        } else {
            this.ui.add_col(1, 0, 2, 1, "Ano -3");
            this.ui.add_col(3, 0, 2, 1, "Ano -2");
            this.ui.add_col(5, 0, 2, 1, "Ano -1");
        }
        this.P.getJTable_Promocao().getTableHeader().setUI(this.ui);
    }

    @Override
    void on_update(String colname, int nRow, String v) {
        this.autocalc();
        this.handler.j.repaint();
        if (!colname.startsWith("valor_")) {
            return;
        }
        String suf = colname.substring(colname.indexOf("_"));
        double total = _lib.round(_lib.to_double(this.getColValue(colname, 3)));
        int i = 0;
        while (i < this.dados.size()) {
            String cv = this.getColValue(colname, i);
            if (total != 0.0 && !cv.equals("")) {
                int perc = (int)_lib.round_dec(_lib.to_double(cv) / total * 100.0, 0);
                this.setColValue("perc" + suf, i, perc == 0 ? "0" : String.valueOf(perc));
            } else {
                this.setColValue("perc" + suf, i, "");
            }
            ++i;
        }
    }

    CHValid_Grp validar(CHValid_Grp err_list) {
        String titulo = "Encargos com promo\u00e7\u00e3o";
        if (err_list == null) {
            err_list = new CHValid_Grp(this, titulo);
        }
        if (!this.isEmpty()) {
            int j = 0;
            while (j < this.dados.size() - 1) {
                if (!this.isRowEmpty(j)) {
                    String mask = "--R-R-R-";
                    TabError[] e = this.isIncompletAll(j, mask.toString());
                    int ii = 0;
                    while (e != null && ii < e.length) {
                        err_list.add_msg(new CHValid_Msg((CBData_Comum)this, e[ii], e[ii].msg(String.valueOf(titulo) + " - " + this.getColValue("mercado_d", j) + ": %T - %o")));
                        ++ii;
                    }
                }
                ++j;
            }
        }
        return err_list;
    }
}

